// Laser Point DrawerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Laser Point Drawer.h"
#include "Laser Point DrawerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLaserPointDrawerDlg dialog

CLaserPointDrawerDlg::CLaserPointDrawerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLaserPointDrawerDlg::IDD, pParent)
{
	//////////////////////////////////////////////////////////////////////////
	//  ʱȭ
	m_pCapture = NULL;
	m_pMainImage = NULL;

	m_iFps_Count = 0;

	m_First_ClientRect = CRect(0,0,592,696);
	//
	//////////////////////////////////////////////////////////////////////////

	//{{AFX_DATA_INIT(CLaserPointDrawerDlg)
	m_Edit_Str_FPS = _T("");
	m_Edit_Str_Event_Info = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLaserPointDrawerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLaserPointDrawerDlg)
	DDX_Control(pDX, IDC_STATIC_ARROW_DOWN, m_Static_Arrow_Down);
	DDX_Control(pDX, IDC_STATIC_TITLE_IMAGE, m_Static_Title_Image);
	DDX_Control(pDX, IDC_EDIT_FPS, m_Edit_FPS_Info);
	DDX_Control(pDX, IDOK, m_Btn_IDOK);
	DDX_Control(pDX, IDC_EDIT_EVENT_INFO, m_Edit_Event_Info);
	DDX_Control(pDX, IDC_BTN_SETUP, m_Btn_Setup);
	DDX_Control(pDX, IDC_BTN_INFOMATION, m_Btn_Infomation);
	DDX_Control(pDX, IDC_BTN_HELP, m_Btn_Help);
	DDX_Control(pDX, IDC_BTN_FIND_STOP, m_Btn_Find_Stop);
	DDX_Control(pDX, IDC_BTN_FIND_START, m_Btn_Find_Start);
	DDX_Control(pDX, IDC_BTN_CAM_STOP, m_Btn_Cam_Stop);
	DDX_Control(pDX, IDC_BTN_CAM_START, m_Btn_Cam_Start);
	DDX_Text(pDX, IDC_EDIT_FPS, m_Edit_Str_FPS);
	DDX_Text(pDX, IDC_EDIT_EVENT_INFO, m_Edit_Str_Event_Info);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLaserPointDrawerDlg, CDialog)
	//{{AFX_MSG_MAP(CLaserPointDrawerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON() 
	ON_BN_CLICKED(IDC_BTN_CAM_START, OnBtnCamStart)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BTN_CAM_STOP, OnBtnCamStop)
	ON_BN_CLICKED(IDC_BTN_FIND_START, OnBtnFindStart)
	ON_BN_CLICKED(IDC_BTN_FIND_STOP, OnBtnFindStop)
	ON_BN_CLICKED(IDC_BTN_INFOMATION, OnBtnInfomation)
	ON_BN_CLICKED(IDC_BTN_HELP, OnBtnHelp)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLaserPointDrawerDlg message handlers

BOOL CLaserPointDrawerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	//////////////////////////////////////////////////////////////////////////
	// * Initialize
	Screen_Initialize();
	m_pMyViewDlg = new CMy_User_View_Dlg;
	m_Edit_Str_FPS.Format("Laser Point Drawer ڴ ݰϴ.");
	UpdateData(FALSE);

	GetClientRect(&m_First_ClientRect);
	//
	//////////////////////////////////////////////////////////////////////////

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLaserPointDrawerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLaserPointDrawerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);		
	}
	else
	{
		CDialog::OnPaint();

		m_Screen_Main_Image_View.Draw_Balck_Background();
		m_Screen_Result_Image_View.Draw_Balck_Background();

		CDC *pDC = GetDC();
		//		pDC->Rectangle(0,0,592,686);
		m_Static_Title_Image.MoveWindow(
			(int)(10 * m_fResize_Value_Width),
			(int)(10 * m_fResize_Value_Height),
			(int)((340+260-25) * m_fResize_Value_Width),
			(int)(100 * m_fResize_Value_Height),
				TRUE);

		m_Edit_FPS_Info.MoveWindow(
			(int)(15 * m_fResize_Value_Width),
			(int)((10+110) * m_fResize_Value_Height),
			(int)((320) * m_fResize_Value_Width),
			(int)(20 * m_fResize_Value_Height),
				TRUE);

		m_Screen_Main_Image_View.MoveWindow(
			(int)(15 * m_fResize_Value_Width),
			(int)((10+130) * m_fResize_Value_Height),
			(int)((320) * m_fResize_Value_Width),
			(int)(240 * m_fResize_Value_Height),
				TRUE);

		m_Static_Arrow_Down.MoveWindow(
			(int)((15+160-20) * m_fResize_Value_Width),
			(int)((10+130+240+5) * m_fResize_Value_Height),
			(int)((40) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);
		
		m_Edit_Event_Info.MoveWindow(
			(int)(15 * m_fResize_Value_Width),
			(int)((10+130+240+40) * m_fResize_Value_Height),
			(int)((320) * m_fResize_Value_Width),
			(int)(20 * m_fResize_Value_Height),
				TRUE);

		m_Screen_Result_Image_View.MoveWindow(
			(int)(15 * m_fResize_Value_Width),
			(int)((10+130+240+60) * m_fResize_Value_Height),
			(int)((320) * m_fResize_Value_Width),
			(int)(240 * m_fResize_Value_Height),
				TRUE);
//////////////////////////////////////////////////////////////////////////
		m_Btn_Cam_Start.MoveWindow(
			(int)(360 * m_fResize_Value_Width),
			(int)((70+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);

		m_Btn_Find_Start.MoveWindow(
			(int)(360 * m_fResize_Value_Width),
			(int)((210+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);

		
		m_Btn_Setup.MoveWindow(
			(int)(360 * m_fResize_Value_Width),
			(int)((350+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);
		
		m_Btn_Infomation.MoveWindow(
			(int)(360 * m_fResize_Value_Width),
			(int)((490+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);
		
		//////////////////////////////////////////////////////////////////////////

		m_Btn_Cam_Stop.MoveWindow(
			(int)(440 * m_fResize_Value_Width),
			(int)((140+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);
		
		m_Btn_Find_Stop.MoveWindow(
			(int)(440 * m_fResize_Value_Width),
			(int)((280+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);
		
		m_Btn_Help.MoveWindow(
			(int)(440 * m_fResize_Value_Width),
			(int)((420+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);
		
		m_Btn_IDOK.MoveWindow(
			(int)(440 * m_fResize_Value_Width),
			(int)((560+60) * m_fResize_Value_Height),
			(int)((130) * m_fResize_Value_Width),
			(int)(30 * m_fResize_Value_Height),
				TRUE);

		ReleaseDC(pDC);
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLaserPointDrawerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CLaserPointDrawerDlg::OnBtnCamStart() 
{
	Start_Cam_Play();
}

BOOL CLaserPointDrawerDlg::Screen_Initialize()
{
	m_Screen_Main_Image_View.SubclassDlgItem(IDC_SCREEN_MAIN,this);
	m_Screen_Result_Image_View.SubclassDlgItem(IDC_SCREEN_RESULT,this);

	//////////////////////////////////////////////////////////////////////////
	// * Window Position Setting
	this->MoveWindow(		100,		100,		340 + 260,		730,TRUE);

	m_Static_Title_Image.MoveWindow(10,10,340+260-25,100,TRUE);
	
	//  ȭ
	
	m_Edit_FPS_Info.MoveWindow(				15,			10+110,		320,	20,		TRUE);
	m_Screen_Main_Image_View.MoveWindow(	15,			10+130,		320,	240,	TRUE);

	m_Static_Arrow_Down.MoveWindow( 15+160-20,10+130+240+5,40,30,TRUE);

	m_Edit_Event_Info.MoveWindow(			15,			10+130+240+40,		320,	20,		TRUE);
	m_Screen_Result_Image_View.MoveWindow(	15,			10+130+240+60,		320,	240,	TRUE);

	//  ȭ
	//  ư x = 320 + 20 = 340  ư x = 320 + 40 + 80 = 440
	m_Btn_Cam_Start.MoveWindow(			360,		70 + 60,		130,		30,		TRUE);
	m_Btn_Find_Start.MoveWindow(		360,		210+ 60,		130,		30,		TRUE);
	m_Btn_Setup.MoveWindow(				360,		350 + 60,		130,		30,		TRUE);
	m_Btn_Infomation.MoveWindow(		360,		490 + 60,		130,		30,		TRUE);
	
	m_Btn_Cam_Stop.MoveWindow(			440,		140+ 60,		130,		30,		TRUE);
	m_Btn_Find_Stop.MoveWindow(			440,		280+ 60,		130,		30,		TRUE);
	m_Btn_Help.MoveWindow(				440,		420 + 60,		130,		30,		TRUE);
	m_Btn_IDOK.MoveWindow(				440,		560 + 60,		130,		30,		TRUE);

	return TRUE;
}

void CLaserPointDrawerDlg::OnTimer(UINT nIDEvent) 
{	
	if(nIDEvent == 1)		// ȭ é
	{
		// ķ ޾ƿ ̹ .
		cvGrabFrame( m_pCapture );
        m_pMainImage = cvRetrieveFrame( m_pCapture );


		cvFlip(m_pMainImage,m_pMainImage);
		/*
		cvNamedWindow("Main");
		cvShowImage("Main",m_pMainImage);
		*/
		
		// 簢   Ʈ  簢  ׸.
		if(m_Calibration.m_pRectangleLineImage != NULL)
		{
			IplImage *pTempImage = (IplImage *)cvClone(m_pMainImage);
			
			for(int i = 0;i<m_pMainImage->height;i++)
			{
				for(int j = 0;j<m_pMainImage->width;j++)
				{
					if(m_Calibration.m_pRectangleLineImage->imageData[i*m_pMainImage->width+j] != 0)
					{
						cvRectangle(pTempImage,cvPoint(j,i),cvPoint(j,i),CV_RGB(255,255,255),1);
					}
				}
			}

			// Static  ӹ޴ Ŭ ̹ Ѱ.
			m_Screen_Main_Image_View.MainImageCopy(pTempImage);
			m_Screen_Main_Image_View.Invalidate(TRUE);

			if(m_FindPoint.m_pResultImage != NULL)
			{
				m_Screen_Result_Image_View.MainImageCopy(m_FindPoint.m_pResultImage);
				m_Screen_Result_Image_View.Invalidate(TRUE);
				cvReleaseImage(&(m_FindPoint.m_pResultImage));
				m_FindPoint.m_pResultImage = NULL;
			}
/*
			cvNamedWindow("MainView");
			cvShowImage("MainView",pTempImage);
*/
			if(m_Calibration.m_pResultImage != NULL)
				m_FindPoint.CVPROnFrame(m_Calibration.m_pResultImage);
			if(m_FindPoint.m_FinalSelect_Num != 0)		// 콺 ̺Ʈ ư  ġҶ.
			{
				m_pMyViewDlg->SetEditBox_InputString(m_FindPoint.m_Info_String);
			}

			if(m_FindPoint.m_bEvent_Point == TRUE)
			{
				m_pMyViewDlg->Set_Timer_Dlg_View();
			}			
			cvReleaseImage(&pTempImage);
		}
		else
		{
			m_Screen_Main_Image_View.MainImageCopy(m_pMainImage);
			m_Screen_Main_Image_View.Invalidate(TRUE);
		}

		//////////////////////////////////////////////////////////////////////////
		//************************************************************************
		//	FPS 
		if((GetCurrentTime() - m_Fps_Time) < 1000)
		{
			m_iFps_Count++;
		}
		else
		{
			m_Edit_Str_FPS.Format("FPS: %3d    Pointer Area: %3d    Noise: %d",
				m_iFps_Count,m_FindPoint.m_DiffLimitPixNum,m_FindPoint.m_DiffPoint);
			UpdateData(FALSE);

			m_Fps_Time = GetCurrentTime();
			m_iFps_Count = 0;
		}
		//
		//************************************************************************
		//////////////////////////////////////////////////////////////////////////

		if(m_FindPoint.m_Check_Point_Exist == TRUE)
		{
			// Laser Pointer  ã .
			CString strPoint_Position;
			CString strEvent;

			strPoint_Position.Format(" < %d , %d > ",m_FindPoint.m_RealPoint.x,m_FindPoint.m_RealPoint.y);

			m_Edit_Str_Event_Info.Format("%s  %s",strPoint_Position,m_FindPoint.m_Info_String);
			UpdateData(FALSE);
		}
		else
		{
			m_Edit_Str_Event_Info.Format("Don't Exist!");
			UpdateData(FALSE);
		}
		//////////////////////////////////////////////////////////////////////////
		// * Check Rectangle
//		m_MyBackGroundController.Draw_Check_Rectangle();

		m_bStart_View = TRUE;
	}
	if(nIDEvent == 2)		// Calibration ȭ ÷
	{
		m_Calibration.Calibration();
	}
	if(nIDEvent == 3)		// ȭ  .
	{
		if(m_bStart_View == TRUE)		// ī޶ ۵ Ǿ .
		{		
			if( (GetCurrentTime() - m_Findtime ) > 3000)
			{
				KillTimer(3);
				AfxMessageBox("͸ ã Ͽϴ.");
				
				m_MyBackGroundController.Background_Eraser();
				Invalidate(TRUE);

				this->ShowWindow(SW_SHOW);
				m_Dlg_Show = TRUE;
				
			}
			else
			{
				this->ShowWindow(SW_HIDE);
				m_Dlg_Show = FALSE;
				m_MyBackGroundController.Draw_White_Board();
				m_Calibration.m_pMainImage = m_pMainImage;
				
				if(m_bStart_Calibration == TRUE)
				{
					m_Calibration.Save_MousePad_OutArea2();
				}
				else
				{
					m_bStart_Calibration = TRUE;
					this->ShowWindow(SW_HIDE);
					m_Dlg_Show = FALSE;
				}
				
				if(m_Calibration.GetbFind4Point() == TRUE)
				{
					this->ShowWindow(SW_SHOW);
					m_Dlg_Show = TRUE;
					KillTimer(3);
					SetTimer(2,0,NULL);
					m_MyBackGroundController.Background_Eraser();
				}
			}			
		}
	}
	if(nIDEvent == 4)		// ķ .
	{
		cvGrabFrame( m_pCapture );
        m_pMainImage = cvRetrieveFrame( m_pCapture );
		cvFlip(m_pMainImage,m_pMainImage);
		
		m_Screen_Main_Image_View.m_bStart = FALSE;
		m_Screen_Main_Image_View.MainImageCopy(m_pMainImage);
		m_Screen_Main_Image_View.Invalidate(TRUE);
	}
	
	CDialog::OnTimer(nIDEvent);
}

void CLaserPointDrawerDlg::OnBtnCamStop() 
{
	Reset_LaserPointFind();

	m_Screen_Main_Image_View.End_View();
	if(m_Calibration.GetbFind4Point() == TRUE)
			m_Screen_Result_Image_View.End_View();

	Invalidate(TRUE);

	
}

void CLaserPointDrawerDlg::OnBtnFindStart() 
{
	Reset_LaserPointFind();
	KillTimer(4);

	if(m_pCapture != NULL)
	{
		return;
	}
	m_MyBackGroundController.Draw_White_Board();
	//  ī޶ 
	
	m_pCapture = cvCaptureFromCAM(0);	

	cvGrabFrame( m_pCapture );
	m_pMainImage = cvRetrieveFrame( m_pCapture );
	
	
	SetTimer(1,0,NULL);
	
	m_Findtime = GetCurrentTime();
	SetTimer(3,0,NULL);

	m_pMyViewDlg->Create(IDD_USER_VIEW_DLG,this);

	m_Screen_Main_Image_View.m_bStart = FALSE;
	m_Screen_Result_Image_View.m_bStart = FALSE;

	this->ShowWindow(SW_HIDE);
	m_Dlg_Show = FALSE;
}

void CLaserPointDrawerDlg::Reset_LaserPointFind()
{
	KillTimer(4);
	KillTimer(2);
	KillTimer(1);
	cvReleaseCapture(&m_pCapture);
	m_pMyViewDlg->DestroyWindow();
	m_bStart_View = FALSE;

	m_Screen_Main_Image_View.m_bStart = TRUE;
	m_Screen_Result_Image_View.m_bStart = TRUE;
}

void CLaserPointDrawerDlg::OnBtnFindStop() 
{
	Reset_LaserPointFind();
	Start_Cam_Play();

	m_Screen_Result_Image_View.End_View();


	Invalidate(TRUE);
}

void CLaserPointDrawerDlg::Start_Cam_Play()
{
	//////////////////////////////////////////////////////////////////////////
	// α׷    ȭ鿡 ̹ .
	KillTimer(4);

	if(m_pCapture != NULL)
		cvReleaseCapture(&m_pCapture);

	m_pCapture = cvCaptureFromCAM(0);

	if(m_pCapture == NULL)
	{
		AfxMessageBox("ǻͿ  ī޶ ϴ.\nα׷  ˴ϴ.");
		exit(1);
	}
	cvGrabFrame( m_pCapture );
	m_pMainImage = cvRetrieveFrame( m_pCapture );
	SetTimer(4,0,NULL);
	//
	//////////////////////////////////////////////////////////////////////////
}

void CLaserPointDrawerDlg::OnBtnInfomation() 
{
	// TODO: Add your control notification handler code here
	
}

void CLaserPointDrawerDlg::OnBtnHelp() 
{
	// TODO: Add your control notification handler code here
	
}

void CLaserPointDrawerDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	m_fResize_Value_Width = (float)(cx) / m_First_ClientRect.Width();
	m_fResize_Value_Height = (float)(cy) / m_First_ClientRect.Height();

	Invalidate(FALSE);
}
